/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.formatter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExcludeRegionList {
    private final List<IRegion> excludes = new ArrayList<IRegion>();
    private final Map<IRegion, EXCLUDE_STRATEGY> excludeActions = new HashMap<IRegion, EXCLUDE_STRATEGY>();
    private static final Comparator<IRegion> REGION_COMPARATOR = new Comparator<IRegion>(){

        @Override
        public int compare(IRegion o1, IRegion o2) {
            return o1.getOffset() - o2.getOffset();
        }
    };

    public boolean isExcluded(int start, int end) {
        if (!this.excludes.isEmpty()) {
            return this.findRegion(start, end) != null;
        }
        return false;
    }

    public EXCLUDE_STRATEGY getExcludeStrategy(int start, int end) {
        IRegion region;
        if (!this.excludes.isEmpty() && (region = this.findRegion(start, end)) != null) {
            return this.excludeActions.get(region);
        }
        return null;
    }

    private IRegion findRegion(int start, int end) {
        for (IRegion region : this.excludes) {
            int regionEnd = region.getOffset() + region.getLength();
            if (start > regionEnd || region.getOffset() > end) continue;
            return region;
        }
        return null;
    }

    public IRegion[] selectValidRanges(int start, int end) {
        ArrayList<Region> result = new ArrayList<Region>();
        for (IRegion region : this.excludes) {
            int regionEnd = region.getOffset() + region.getLength();
            if (start > regionEnd || region.getOffset() > end) continue;
            if (start < region.getOffset()) {
                int validEnd = Math.min(end, region.getOffset());
                result.add(new Region(start, validEnd - start));
            }
            if ((start = regionEnd) > end) break;
        }
        if (start < end) {
            result.add(new Region(start, end - start));
        }
        return result.toArray(new IRegion[result.size()]);
    }

    public List<IRegion> getExcludes() {
        return Collections.unmodifiableList(this.excludes);
    }

    public void excludeRegion(IRegion region, EXCLUDE_STRATEGY strategy) {
        int start = region.getOffset();
        int end = region.getOffset() + region.getLength();
        if (!this.excludes.isEmpty()) {
            Iterator<IRegion> i = this.excludes.iterator();
            while (i.hasNext()) {
                IRegion r = i.next();
                int rEnd = r.getOffset() + r.getLength();
                if (r.getOffset() > end || start > rEnd) continue;
                if (region.getOffset() >= r.getOffset() && region.getOffset() + region.getLength() <= rEnd) {
                    return;
                }
                if (r.getOffset() < start) {
                    start = r.getOffset();
                }
                if (rEnd > end) {
                    end = rEnd;
                }
                i.remove();
            }
        }
        if (start == region.getOffset() && end == region.getOffset() + region.getLength()) {
            this.excludes.add(region);
            this.excludeActions.put(region, strategy);
        } else {
            Region newRegion = new Region(start, end - start);
            this.excludes.add((IRegion)newRegion);
            this.excludeActions.put((IRegion)newRegion, strategy);
        }
        Collections.sort(this.excludes, REGION_COMPARATOR);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EXCLUDE_STRATEGY {
        SKIP,
        WRITE_AS_IS;

    }
}

